# 画面設計書 46-フォームレイアウト（Bootstrap 3 水平）

## 概要

本ドキュメントは、Symfony Twig Bridgeが提供するBootstrap 3対応の水平フォームレイアウトテーマ（bootstrap_3_horizontal_layout.html.twig）の画面設計書である。bootstrap_3_layoutを基盤として、Bootstrap 3のグリッドシステムを利用した水平配置（ラベルとフィールドが横並び）のフォームレンダリングを行う。

### 本画面の処理概要

**業務上の目的・背景**：水平フォームレイアウトは、ラベルを左側に配置しフィールドを右側に配置することで、フォーム全体のコンパクトさと視認性を両立させるレイアウトである。Bootstrap 3のグリッドシステム（col-sm-2 / col-sm-10）を使用して、ラベル列とフィールド列を適切な幅で配置する。管理画面やデータ入力フォームなど、画面の横幅を効率的に活用したい場合に適している。

**画面へのアクセス方法**：Symfonyの設定で`twig.form_themes`に`'bootstrap_3_horizontal_layout.html.twig'`を指定する。

**主要な操作・処理内容**：
1. form要素にform-horizontalクラスを適用
2. ラベルをcol-sm-2クラスで左側に配置
3. フィールドをcol-sm-10クラスで右側に配置
4. ラベルがfalseの場合、空のdiv.col-sm-2でスペースを確保
5. submit/resetボタン行はラベル列を空にしてcol-sm-10列にボタンを配置
6. チェックボックス行はラベル列を空にしてcol-sm-10列にウィジェットを配置
7. bootstrap_3_layoutの全ウィジェットブロック（form-control, btn等）をそのまま継承

**画面遷移**：本テーマファイル自体は画面遷移を定義しない。

**権限による表示制御**：テーマファイル自体には権限制御機能はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | Form | 主機能 | Bootstrap 3対応の水平フォームレイアウトテーマによるフォームレンダリング |
| 36 | Twig Bridge | 主機能 | Twig Bridgeのフォームレンダリング拡張によるBootstrap 3水平用ブロック定義 |

## 画面種別

フォームテーマ（Twigテンプレート断片）

## URL/ルーティング

本テーマファイルは直接URLに紐づかない。

```yaml
twig:
    form_themes: ['bootstrap_3_horizontal_layout.html.twig']
```

## 入出力項目

bootstrap_3_layoutと同一の変数に加え、以下の水平レイアウト固有のブロックを使用する。

| ブロック名 | デフォルト値 | 説明 |
|-----------|-------------|------|
| form_label_class | col-sm-2 | ラベル列のグリッドクラス |
| form_group_class | col-sm-10 | フィールド列のグリッドクラス |

## 表示項目

### オーバーライドされた主要ブロック一覧

| ブロック名 | 説明 | 出力HTML構造 |
|-----------|------|-------------|
| form_start | formタグにform-horizontalクラスを追加 | `<form class="form-horizontal">` |
| form_label | ラベルにcol-sm-2クラスを追加、label=falseで空divを出力 | `<label class="control-label col-sm-2">` or `<div class="col-sm-2"></div>` |
| form_label_class | ラベル列のグリッドクラス定義 | `col-sm-2` |
| form_row_render | 水平レイアウトの行構造 | `<div class="form-group"><label>...</label><div class="col-sm-10">widget+help+errors</div></div>` |
| submit_row | 送信ボタンの水平レイアウト行 | `<div class="form-group"><div class="col-sm-2"></div><div class="col-sm-10">button</div></div>` |
| reset_row | リセットボタンの水平レイアウト行 | submit_rowと同構造 |
| form_group_class | フィールド列のグリッドクラス定義 | `col-sm-10` |
| checkbox_row | チェックボックスの水平レイアウト行 | `<div class="form-group"><div class="col-sm-2"></div><div class="col-sm-10">widget+help+errors</div></div>` |

## イベント仕様

### 1-水平レイアウトでのフォームレンダリング

Bootstrap 3の水平フォームレイアウト構造でHTMLが生成される。

主なHTML出力例：
```html
<form class="form-horizontal" method="post">
    <!-- 通常フィールド -->
    <div class="form-group">
        <label class="control-label col-sm-2" for="form_name">Name</label>
        <div class="col-sm-10">
            <input type="text" class="form-control" id="form_name" />
            <span class="help-block">...</span>
        </div>
    </div>
    <!-- 送信ボタン -->
    <div class="form-group">
        <div class="col-sm-2"></div>
        <div class="col-sm-10">
            <button type="submit" class="btn-default btn">Submit</button>
        </div>
    </div>
</form>
```

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| フォームレンダリング | なし | なし | テンプレートはHTMLレンダリングのみ |

## メッセージ仕様

bootstrap_3_layoutと同一。

## 例外処理

テーマテンプレート自体は例外をスローしない。

## 備考

- `{% use 'bootstrap_3_layout.html.twig' %}`により、bootstrap_3_layoutの全ブロックを基盤として利用
- 4層の継承構造：form_div_layout → bootstrap_base_layout → bootstrap_3_layout → bootstrap_3_horizontal_layout
- グリッドクラスはform_label_classとform_group_classブロックで定義されており、テンプレートのオーバーライドでカスタマイズ可能
- デフォルトのグリッド比率はラベル2:フィールド10（合計12カラム）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

FormViewの共通変数を把握する。No.43のStep 1を参照。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FormView.php | `src/Symfony/Component/Form/FormView.php` | フォームビューの構造を理解する |

#### Step 2: 基盤テーマのチェーンを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | 最も基盤となるテーマ |
| 2-2 | bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | Bootstrap共通の基盤テーマ |
| 2-3 | bootstrap_3_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_layout.html.twig` | Bootstrap 3標準テーマ |

#### Step 3: 水平レイアウト固有のオーバーライドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | bootstrap_3_horizontal_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_horizontal_layout.html.twig` | 水平レイアウト固有のブロックを理解する |

**主要処理フロー**:
1. **L1**: `{% use 'bootstrap_3_layout.html.twig' %}` - 基盤テンプレートの読み込み
2. **L3-6**: `form_start` - form-horizontalクラスの追加
3. **L10-17**: `form_label` - col-sm-2クラスの追加、label=falseで空div出力
4. **L19-21**: `form_label_class` - ラベル列クラス定義（col-sm-2）
5. **L25-34**: `form_row_render` - 水平グリッド構造（label + div.col-sm-10にwidget+help+errors）
6. **L36-43**: `submit_row` - 送信ボタンの水平配置
7. **L45-52**: `reset_row` - リセットボタンの水平配置
8. **L54-56**: `form_group_class` - フィールド列クラス定義（col-sm-10）
9. **L58-67**: `checkbox_row` - チェックボックスの水平配置

### プログラム呼び出し階層図

```
{{ form_row(form.field) }}
    |
    +-- form_row [form_div_layoutから継承]
    |       +-- form_row_render [bootstrap_3_horizontal_layout オーバーライド]
    |               |
    |               +-- <div class="form-group">
    |               +-- form_label [bootstrap_3_horizontal_layout オーバーライド]
    |               |       +-- <label class="control-label col-sm-2">
    |               +-- <div class="col-sm-10">
    |               |       +-- form_widget [bootstrap_3_layoutから継承]
    |               |       +-- form_help [bootstrap_3_layoutから継承]
    |               |       +-- form_errors [bootstrap_3_layoutから継承]
    |               +-- </div></div>
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FormView ---------> TwigRendererEngine ---------> ブロック解決
                    テーマ検索順序:                     |
                    1. bootstrap_3_horizontal           v
                    2. bootstrap_3_layout         Bootstrap 3 水平レイアウトHTML
                    3. bootstrap_base_layout      (<form class="form-horizontal">,
                    4. form_div_layout             <div class="form-group">,
                                                   <label class="col-sm-2">,
                                                   <div class="col-sm-10">, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| bootstrap_3_horizontal_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_horizontal_layout.html.twig` | テンプレート | Bootstrap 3水平フォームテーマ（全68行） |
| bootstrap_3_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_3_layout.html.twig` | テンプレート | Bootstrap 3標準フォームテーマ（全217行） |
| bootstrap_base_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_base_layout.html.twig` | テンプレート | Bootstrap共通基盤テーマ（全209行） |
| form_div_layout.html.twig | `src/Symfony/Bridge/Twig/Resources/views/Form/form_div_layout.html.twig` | テンプレート | 最も基盤となるフォームレイアウトテーマ（全482行） |
